package ch.frankel.blog.p6spy;

import java.util.Date;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.criterion.Example;
import org.junit.BeforeClass;
import org.junit.Test;

import ch.frankel.blog.p6spy.model.Person;

/**
 * Test that show the SQL logging feature of P6Spy.
 * 
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 * @since 10 avr. 2010
 */
public class LogSqlTest {

    private static SessionFactory factory;

    @BeforeClass
    public static void setUpBeforeClass() {

        AnnotationConfiguration cfg = new AnnotationConfiguration();

        cfg.addAnnotatedClass(Person.class);

        cfg.configure();

        factory = cfg.buildSessionFactory();
    }

    @Test
    public void testHibernateLogging() {

        Session session = factory.openSession();

        try {

            Person person = new Person();

            person.setId(1L);
            person.setFirstName("Johnny");
            person.setLastName("Be Good");
            person.setBirthDate(new Date());

            Criteria criteria = session.createCriteria(Person.class);

            criteria.add(Example.create(person)).list();

            session.flush();

        } finally {

            session.close();
        }
    }
}
